import sys, os
import importlib.util
from contextlib import contextmanager
sys.path.append(os.environ['VMWARE_PYTHON_PATH'])

@contextmanager
def suppress_stdout():
    with open(os.devnull, "w") as devnull:
        old_stdout = sys.stdout
        sys.stdout = devnull
        try:
            yield
        finally:
            sys.stdout = old_stdout
def get_vmidentity_classpath():
    with suppress_stdout():
        spec = importlib.util.spec_from_file_location("VMwareIdentityFirstBoot",
                                                      "/usr/lib/vmidentity/firstboot/vmidentity-firstboot.py")
        vmidfb = importlib.util.module_from_spec(spec)
        sys.modules["VMwareIdentityFirstBoot"] = vmidfb
        spec.loader.exec_module(vmidfb)
        cp = vmidfb.VMwareIdentityFirstBoot()
        class_path = cp._VMwareIdentityFirstBoot__classpath
    return class_path

if __name__ == '__main__':
    print(get_vmidentity_classpath())